<?php

// ====================== HANDLE MESSAGE ======================
if(isset($update["message"])){
    $chat_id = $update["message"]["chat"]["id"];
    $user_id = $update["message"]["from"]["id"];
    $text    = $update["message"]["text"];  
    $username = $update["message"]["from"]["username"] ?? "ندارد";

    if(isset($update["message"]["photo"])){
        $text = $update["message"]["caption"] ?? "";
        $file_id = end($update["message"]["photo"])["file_id"];
    }

    if(!isset($update["message"]["text"]) && !isset($update["message"]["photo"])) {
        sendMessage($chat_id, "⚠️ فرمت فایل مجاز نیست! فعلا فقط متن و تصویر پشتیبانی می‌شود.");
        exit;
    }


    if($text=="/start"){

    $subs->setState($user_id, "menu");

    $isNew = $subs->addUserIfNotExists( $user_id, $username);

        sendMessage($chat_id,
"سلام!
من ربات هوش مصنوعی شما هستم 🤖
می‌تونم به شما کمک کنم تا متن بنویسید، ترجمه کنید، تصویر بسازید و حتی داده‌ها رو تحلیل کنید.
بیاید شروع کنیم! کدوم گزینه رو می‌خواید امتحان کنید؟
",mainMenu());

    $admin_ids = $config["ADMIN_IDS"];

    if($isNew){
        foreach($admin_ids as $admin){
            sendMessage($admin, "👤 کاربر جدید وارد ربات شد\nID: $user_id\nUsername: @$username");
        }
    }

    exit;
    
    }elseif($text === "🔙 برگشت به منوی اصلی"){

        removeReplyKeyboard($chat_id);

        $subs->setState($user_id, "menu");

        sendMessage($chat_id,"برای ادامه، یکی از گزینه‌های زیر رو انتخاب کن 👇",mainMenu());

        exit;
    }

    $currentState = $subs->getState($user_id);
    
    if($currentState == "chat_mode_think"){
        sendMessage($chat_id,"لطفا منتظر بمانید... \n برای انصراف از درخواست روی دکمه زیر کلیک کنید",inline_cancelBtn());
        exit;
    }if($currentState == 'chat_mode_image'){

        alert($callback_id,"در حال توسعه این بخش هستیم. به زودی اضافه میشه");

    }elseif (str_starts_with($currentState, "chat_mode_")) {
        
        // بررسی اشتراک
        if(!$subs->canUseTokens ($user_id)){
            sendMessage($chat_id, "❌ موجودی کیف پول شما کافی نیست.", inline_cancelBtn());
            exit;
        }

        if($text === "🆕 شروع گفتگو جدید"){
            $subs->clearChatHistory($user_id);
            sendMessage($chat_id, "🗑️ تاریخچه چت شما پاک شد.", cancelBtn());
            exit;
        }

        $subs->setState($user_id,"chat_mode_think");

        $context = $subs->getUserChatContext( $user_id, 10);
        $context[] = ["role"=>"user","text"=>$text];

        $msg = sendMessage($chat_id,"در حال فکر کردن...");
        $msgId = $msg["result"]["message_id"];
        
        sendTypingAction($chat_id);

        if(isset($update["message"]["photo"])){
            $img = get_image_base64($chat_id ,$file_id);
            $answer = $gemini->askWithContext($context,$currentState,true,$img);
        }else{
            $answer = $gemini->askWithContext($context,$currentState);
        }

        deleteMessage($chat_id,$msgId);

        $subs->addChatMessage($user_id, "assistant", $answer);
        
        $responseText = $answer["text"];
        $usedTokens   = $answer["tokens"];

        // کم کردن توکن از کاربر
        $newBalance = $subs->reduceTokens($user_id, $usedTokens);
        
        if($currentState == 'chat_mode_talk' || $currentState == 'chat_mode_content' || $currentState == 'chat_mode_translate' || $currentState == 'chat_mode_analysis' ){
            sendMessage($chat_id,"🤖 پاسخ:\n\n$responseText",cancelBtn());
        }elseif($currentState == 'chat_mode_code'){

            $caption = "";
            $code = "";

            if (preg_match('/===CAPTION===(.*?)===ENDCAPTION===/s', $responseText, $m)) {
                $caption = trim($m[1]);
            }

            if (preg_match('/===CODE===(.*?)===ENDCODE===/s', $responseText, $m)) {
                $code = trim($m[1]);
            }

            $tempDir = __DIR__ . "/temp";

            if (!is_dir($tempDir)) {
                if(!mkdir($tempDir, 0777, true)) {
                    sendMessage($chat_id,"❌ ساخت پوشه temp ناموفق بود!");
                    return;
                }
            }

            if(!is_writable($tempDir)) {
                sendMessage($chat_id,"❌ پوشه temp قابل نوشتن نیست!");
                return;
            }

            if(empty($code)){
                sendMessage($chat_id,"⚠️ پاسخ خالی است و فایل ساخته نشد!");
                return;
            }

            $filename = "answer_" . time() . ".txt";
            $filePath = "$tempDir/$filename";

            if(file_put_contents($filePath, $code) === false){
                sendMessage($chat_id,"❌ نوشتن فایل با خطا مواجه شد!");
                return;
            }

            sendMessage($chat_id, "📄 توضیحات:\n" . $caption);                
            $sent = sendDocument($chat_id, $filePath, "فایل کد آماده شد 🔥");

            if($sent){
                // ==== حذف فایل موقت (اختیاری) ====
                unlink($filePath);
            } else {
                sendMessage($chat_id,"⚠️ ارسال فایل با خطا مواجه شد!");
            }

        }elseif($currentState == 'chat_mode_code'){
            
        }else{
            sendMessage($chat_id,"مشکلی در ارسال پاسخ پیش امد. لطفا مجدد تلاش کنید");
        }
        
        $subs->setState($user_id,$currentState);
    }else{
        sendMessage($chat_id,"برای ادامه، یکی از گزینه‌های زیر رو انتخاب کن 👇",mainMenu());
    }

    


    
}