<?php

// ====================== FUNCTIONS ======================

// توابع کمکی
function requestTelegram($method,$data=[]){
    global $config;
    $url = "https://api.telegram.org/bot{$config['BOT_TOKEN']}/$method";
    return json_decode(file_get_contents($url."?".http_build_query($data)),true);
}

function sendMessage($chat_id, $text, $keyboard = null) {
    
    $maxLength = 4096; // حداکثر طول پیام تلگرام
    $offset = 0;
    $textLength = mb_strlen($text, 'UTF-8');


    while ($offset < $textLength) {
        $messagePart = mb_substr($text, $offset, $maxLength, 'UTF-8');
        $offset += $maxLength;

        $data = ["chat_id" => $chat_id, "text" => $messagePart];

        // فقط در پیام اول کیبورد را اضافه کن
        if ($keyboard && $offset <= $maxLength) {
            $data["reply_markup"] = json_encode($keyboard);
        }

        requestTelegram("sendMessage", $data);
    }


}

function sendTypingAction($chat_id) {
    $data = [
    "chat_id" => $chat_id,
    "action" => "typing" // "typing" برای متن، "upload_photo" و غیره هم می‌تونید استفاده کنید
    ];
    return requestTelegram("sendChatAction", $data);
}

function deleteMessage($chat_id, $message_id){
    $data = [
        "chat_id" => $chat_id,
        "message_id" => $message_id
    ];

    return requestTelegram("deleteMessage", $data);
}

function editMessage($chat_id, $msg_id, $text, $keyboard = null){
    $data = [
        "chat_id" => $chat_id,
        "message_id" => $msg_id,
        "text" => $text
    ];

    // اگر کیبورد جدید داده شد، اضافه کن
    if($keyboard){
        $data["reply_markup"] = json_encode($keyboard);
    }

    return requestTelegram("editMessageText", $data);
}

function sendDocument($chat_id, $file_path, $caption = null, $keyboard = null) {

    global $config;

    $url = "https://api.telegram.org/bot" . $config['BOT_TOKEN'] . "/sendDocument";

    $post_fields = [
        'chat_id' => $chat_id,
        'document' => new CURLFile($file_path)
    ];

    if ($caption) {
        $post_fields['caption'] = $caption;
    }

    if ($keyboard) {
        $post_fields['reply_markup'] = json_encode($keyboard);
    }

    $ch = curl_init(); 
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type:multipart/form-data"]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields); 
    $output = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if($httpCode !== 200){
        return false; // خطا
    }

    $json = json_decode($output, true);
    return $json['ok'] ?? false;
}

function sendPhoto($chat_id, $file_path, $caption = null, $keyboard = null) {
    global $config;

    $url = "https://api.telegram.org/bot" . $config['BOT_TOKEN'] . "/sendPhoto";

    $post_fields = [
        'chat_id' => $chat_id,
        'photo' => new CURLFile($file_path)
    ];

    if ($caption) $post_fields['caption'] = $caption;
    if ($keyboard) $post_fields['reply_markup'] = json_encode($keyboard);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ["Content-Type:multipart/form-data"],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => $post_fields
    ]);

    $output = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if($httpCode !== 200){
        return false;
    }

    $json = json_decode($output, true);
    return $json['ok'] ?? false;
}

function alert($callback_query_id, $text, $show_alert = false){
    $data = [
        "callback_query_id" => $callback_query_id,
        "text" => $text,
        "show_alert" => $show_alert // true → نمایش به صورت Pop-up، false → نمایش کوتاه در پایین
    ];

    return requestTelegram("answerCallbackQuery", $data);
}


function removeReplyKeyboard($chat_id, $text = "🔙 به عقب برگشتیم"){
    $keyboard = [
        "remove_keyboard" => true
    ];

    return sendMessage($chat_id, $text, $keyboard);
}

function mainMenu(){
    return ["inline_keyboard"=>[
        [
            ["text"=>"🧩 خدمات ربات","callback_data"=>"service"],
            ["text"=>"💬 شروع گفتگو","callback_data"=>"chat_mode_talk"]
        ],
        [
            ["text"=>"📘 راهنمای استفاده","callback_data"=>"help"],
            ["text"=>"🎧 پشتیبانی","callback_data"=>"contact_us"],
        ],
        [
            ["text"=>"💰 کیف پول و شارژ موجودی","callback_data"=>"status"],
        ],
    ]];
}

function planMenu(){
    return ["inline_keyboard"=>[
        [
            ["text"=>"🏆 ۱۵۰ تومان - پلن طلایی","callback_data"=>"select_plan1"],
        ],
        [
            ["text"=>"🥈 ۱۳۰ تومان - پلن نقره‌ای","callback_data"=>"select_plan2"],
        ],
        [
            ["text"=>"🥉 ۱۱۵ تومان - پلن برنزی","callback_data"=>"select_plan3"],
        ],
        [
            ["text"=>"🔙 برگشت به منوی اصلی","callback_data"=>"menu"]
        ]
    ]];
}

function serviceModeMenu(){
    return ["inline_keyboard"=>[
        [
            ["text"=>"💻 تولید و تغییر کد", "callback_data"=>"chat_mode_code"],
        ],
        [
            ["text"=>"📝 تولید متن — نوشتن مقاله، کپشن، ایمیل و…", "callback_data"=>"chat_mode_content"],
        ],
        [
            ["text"=>"🌐 ترجمه — ترجمه متن به زبان‌های مختلف", "callback_data"=>"chat_mode_translate"],
        ],
        [
            ["text"=>"🖼️ تولید تصویر — ساخت تصویر یا طرح گرافیکی", "callback_data"=>"chat_mode_image"],
        ],
        [
            ["text"=>"📊 تحلیل داده — پردازش و تحلیل داده‌ها", "callback_data"=>"chat_mode_analysis"],
        ],
        inline_menu_cancelBtn()
    ]];
}

function statusMenu($user_id){

    global $subs;
    $user_info = $subs->getUserInfo($user_id);
    $date = $subs->check($user_id);

    return ["inline_keyboard"=>[
        [
            ["text"=>$user_info['username'],"callback_data"=>"nitrova"],["text"=>"نام کاربری","callback_data"=>"nitrova"]
        ],
        [
            ["text"=>$user_info['id'],"callback_data"=>"nitrova"],["text"=>"ایدی عددی","callback_data"=>"nitrova"]
        ],
        [
            ["text"=>($date ? number_format($date['token']) : "0")." تومان","callback_data"=>"nitrova"],["text"=>"موجودی کیف پول","callback_data"=>"nitrova"]
        ],
        [
            ["text"=>"💳 شارژ کیف پول","callback_data"=>"nitrova"],
        ],
        inline_menu_cancelBtn()
    ]];
}

function inline_cancelBtn($text = "🔙 بستن چت"){
    return ["inline_keyboard"=>[
        [
            ["text"=>$text,"callback_data"=>"menu"]
        ]
    ]];
}

function inline_menu_cancelBtn(){
    return 
        [
            ["text"=>"🔙 برگشت به منوی اصلی","callback_data"=>"menu"]
        ];
}

function cancelBtn(){
    return [
        "keyboard" => [
            [["text" => "🆕 شروع گفتگو جدید"]],
            [["text" => "🔙 برگشت به منوی اصلی"]]
        ],
        "resize_keyboard" => true,     // اندازه دکمه مناسب می‌شود
        "one_time_keyboard" => true    // بعد از کلیک محو شود (اختیاری)
    ];
}

function get_image_base64($chat_id, $file_id){

    global $config, $gemini, $subs;

    // دریافت لینک فایل از تلگرام
    $fileInfo = requestTelegram("getFile", ["file_id" => $file_id]);
    $filePath = $fileInfo["result"]["file_path"];

    $fileUrl = "https://api.telegram.org/file/bot{$config['BOT_TOKEN']}/{$filePath}";

    // دانلود فایل
    $imageData = file_get_contents($fileUrl);
    if(!$imageData){
        sendMessage($chat_id, "❌ خطا در دانلود تصویر");
        return;
    }

    // تبدیل به Base64
    return base64_encode($imageData);

}

