<?php


$config = require "config.php";
require "GeminiService.php";
require "Subscription.php";
require "PaymentGateway.php";

// اتصال PDO
$dsn = "mysql:host=localhost;dbname=nitrova;charset=utf8mb4";
$pdo = new PDO($dsn, $config["dbUserName"], $config["dbPassword"], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
]);


// نمونه‌سازی کلاس‌ها
$subs = new Subscription($pdo);
$gemini = new GeminiService($pdo, $config["MODEL"]);
$payment = new PaymentGateway($pdo,$config["PAYMENT_URL"]);


// دریافت آپدیت تلگرام
$update = json_decode(file_get_contents("php://input"),true);
if(!$update) exit;

include_once "functions.php";
include_once "message-handler.php";
include_once "callback-handler.php";

