<?php
class Subscription {
    private $pdo;

    public function __construct($pdo){
        $this->pdo = $pdo;
    }

    public function getUserInfo($user_id){
        $stmt = $this->pdo->prepare("SELECT * FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }


    public function addUserIfNotExists($user_id, $username){
        // بررسی وجود کاربر
        $stmt = $this->pdo->prepare("SELECT COUNT(*) FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        $exists = $stmt->fetchColumn();
        $free_token = 10000;

        if($exists == 0){
            // اضافه کردن کاربر
            $stmt = $this->pdo->prepare("INSERT INTO users (id, username,token) VALUES (?, ?, ?)");
            $stmt->execute([$user_id, $username,$free_token]);
            return true; // کاربر جدید اضافه شد
        }
        return false; // قبلاً وجود داشت
    }

    public function check($user_id){
        $stmt = $this->pdo->prepare("SELECT subscription_expire,token FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        $fetch = $stmt->fetch(PDO::FETCH_ASSOC);
        $expire = $fetch["subscription_expire"];
        $token = $fetch["token"];

        if(!$fetch) return false; // اشتراک وجود ندارد

        $expireTime = strtotime($expire);
        $now = time();

        
        if($expire){
            $daysLeft = ceil(($expireTime - $now) / 86400);
        }else{
            $daysLeft = 0;
        }
        
        return ['day'=>$daysLeft,'token'=>$token];

        
    }


    public function add($user_id, $days){
        $expire_date = date("Y-m-d H:i:s", strtotime("+$days days"));

        $stmt = $this->pdo->prepare("INSERT INTO users (id, subscription_expire) VALUES (?,?) 
                                     ON DUPLICATE KEY UPDATE subscription_expire=?");
        $stmt->execute([$user_id,$expire_date,$expire_date]);
    }

    public function getExpireDate($user_id){
        $stmt = $this->pdo->prepare("SELECT subscription_expire FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        return $stmt->fetchColumn();
    }

    public function notifyAdminsOnce($admin_ids, $user_id, $username){
    // اگر کاربر جدید است، نوتیف بفرست
    $isNew = $this->addUserIfNotExists( $user_id, $username);
    if($isNew){
        foreach($admin_ids as $admin){
            sendMessage($admin, "👤 کاربر جدید وارد ربات شد\nID: $user_id\nUsername: @$username");
        }
    }
    }

    // محدودیت پیام روزانه برای کاربران بدون اشتراک
    public function canUseTokens($user_id){
        // گرفتن تعداد توکن‌های فعلی
        $stmt = $this->pdo->prepare("SELECT token FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        $tokens = $stmt->fetchColumn();

        if($tokens === false){
            return false; // کاربر پیدا نشد
        }

        // اگر توکن کافی نیست
        if($tokens <= 0){
            return false; // توکن کافی نیست
        }

        return true; // توکن‌ها با موفقیت کم شدند
    }


     public function getState($user_id){
        $stmt = $this->pdo->prepare("SELECT state FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        $state = $stmt->fetchColumn();
        return $state ?? 'menu';
    }

    public function setState($user_id, $state){
        $stmt = $this->pdo->prepare("UPDATE users SET state=? WHERE id=?");
        $stmt->execute([$state,$user_id]);
    }

    // ذخیره پیام و حذف پیام‌های قدیمی
    function addChatMessage($user_id, $role, $message){

        if($message == "⚠️ پاسخی از جیمنای دریافت نشد.") return;

        $stmt = $this->pdo->prepare("INSERT INTO user_chat_history(user_id, role, text) VALUES (?,?,?)");
        $stmt->execute([$user_id, $role, $message]);

        // فقط ۱۰ پیام آخر برای هر کاربر نگه داشته شود
        $stmt = $this->pdo->prepare("
            DELETE FROM user_chat_history
            WHERE user_id=? AND id NOT IN (
                SELECT id FROM (
                    SELECT id FROM user_chat_history WHERE user_id=? ORDER BY id DESC LIMIT 10
                ) tmp
            )
        ");
        $stmt->execute([$user_id, $user_id]);
    }

    // دریافت تاریخچه آخرین n پیام
    function getUserChatContext($user_id, $limit = 10) {
        $limit = (int)$limit; // امنیت: اطمینان از عددی بودن

        // گرفتن آخرین n پیام از دیتابیس
        $stmt = $this->pdo->prepare("
            SELECT role, text 
            FROM user_chat_history 
            WHERE user_id = :user_id 
            ORDER BY id DESC
            LIMIT $limit
        ");
        $stmt->execute([':user_id' => $user_id]);

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        print_r(array_reverse($rows));

        // بازگرداندن به ترتیب قدیمی → جدید
        return array_reverse($rows);
    }
    public function clearChatHistory($user_id){
        $stmt = $this->pdo->prepare("DELETE FROM user_chat_history WHERE user_id=?");
        $stmt->execute([$user_id]);
    }

    function calculateTokenCost($usedTokens, $type = 'output', $usdToToman = 120000, $profitMargin = 1.5) {
        $ratePerMillion = [
            'input'  => 0.15,
            'output' => 1,
            'flash'  => 3.5
        ];

        if(!isset($ratePerMillion[$type])){
            throw new Exception("نوع توکن معتبر نیست. ورودی، خروجی یا flash مجاز است.");
        }

        // تبدیل دلار به تومان برای 1,000,000 توکن
        $costPerMillionToman = $ratePerMillion[$type] * $usdToToman;

        // هزینه برای تعداد توکن مصرف شده
        $cost = ($usedTokens / 1000000) * $costPerMillionToman;

        // اعمال سود
        $costWithProfit = $cost * (1 + $profitMargin);

        return round($costWithProfit, 2); // گرد کردن تا ۲ رقم اعشار
    }

    public function reduceTokens($user_id, $usedTokens){

        $usedTokens = $this->calculateTokenCost($usedTokens,'output');

        // گرفتن توکن فعلی
        $stmt = $this->pdo->prepare("SELECT token FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        $tokens = $stmt->fetchColumn();

        if($tokens === false){
            return false; // کاربر وجود ندارد
        }

        // کم کردن توکن
        $newTokens = $tokens - $usedTokens;

        if($newTokens < 0){
            $newTokens = 0;
        }

        // آپدیت دیتابیس
        $stmt = $this->pdo->prepare("UPDATE users SET token=? WHERE id=?");
        $stmt->execute([$newTokens, $user_id]);

        return $newTokens;
    }


}
