<?php
class PaymentGateway {
    private $pdo;
    private $paymentUrl;

    public function __construct($pdo, $url){
        $this->pdo = $pdo;
        $this->paymentUrl = $url;
    }

    public function createPaymentLink($user_id, $amount){
        // ایجاد رکورد pending
        $stmt = $this->pdo->prepare("INSERT INTO payments (user_id, amount) VALUES (?,?)");
        $stmt->execute([$user_id,$amount]);
        $payment_id = $this->pdo->lastInsertId();

        // لینک پرداخت واقعی با پارامتر تراکنش
        return $this->paymentUrl."?payment_id=$payment_id";
    }

    public function handleCallback($payment_id, $status){
        $stmt = $this->pdo->prepare("UPDATE payments SET status=? WHERE id=?");
        $stmt->execute([$status,$payment_id]);
        if($status=="success"){
            // فعال کردن اشتراک کاربر
            $stmt2 = $this->pdo->prepare("SELECT user_id FROM payments WHERE id=?");
            $stmt2->execute([$payment_id]);
            $user_id = $stmt2->fetchColumn();
            if($user_id){
                $subs = new Subscription($this->pdo);
                $subs->add($user_id,30); // فعال سازی 30 روزه
            }
        }
    }
}
